//
//  foreamCamCtrl.h
//  foreamApiDemo
//
//  Created by kc.chen on 11/04/2018.
//  Copyright © 2018 kc.chen. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GCDAsyncUdpSocket.h"
#import "camInfo.h"

@protocol foreamCamCtrlDelegate <NSObject>

@optional
- (void)camIsOffline:(NSString *)camSearial;
- (void)camIsOnline:(NSString *)camSearial MsgValue:(NSString *) msgValue  CamIP:(NSString *) camIP OwnerId:(NSString *) ownerId;
- (void)updateNumberOfCamOnline:(NSMutableArray *)scanOnlineCamList;
@end

@interface foreamCamCtrl : NSObject <GCDAsyncUdpSocketDelegate>

@property (nonatomic, strong) GCDAsyncUdpSocket *sendSocket;        // 发送广播
//@property (nonatomic, strong) GCDAsyncUdpSocket *reciveSocket;      // 接受数据
@property (nonatomic, strong) NSMutableArray *cam;      // 存储设备信息
@property (nonatomic, strong) NSMutableArray *onlineCamList; // 缓存timer时间内扫描到的设备信息
@property (nonatomic, strong) NSTimer *scanOnlineCamtimer;                    //扫描在线相机的定时器，等待时长为3s
@property (nonatomic, strong) NSTimer *timer;                    // 检测 设备消失
@property (nonatomic) BOOL bScaning;                    //是否正在扫描
@property (weak) id<foreamCamCtrlDelegate> delegate;

//Common-----------------------------
+ (foreamCamCtrl *) getInstance;
- (void)setupSocket;
-(void)startListener;
-(void)stopListener;
-(void)startScan;
-(void)stopScan;
-(NSString *)generateQRCode:(NSString *) ssid password:(NSString *)pwd streamType:(NSString *) streamType;
- (NSString *)fetchSSIDName;
- (BOOL) isWiFiEnabled;
-(void) clearAllData;
@end
