//
//  foreamCamCtrl.m
//  foreamApiDemo
//
//  Created by kc.chen on 11/04/2018.
//  Copyright © 2018 kc.chen. All rights reserved.
//

#import "foreamCamCtrl.h"
#import <ifaddrs.h>
#import <arpa/inet.h>
#import <SystemConfiguration/CaptiveNetwork.h>
#import <CoreLocation/CoreLocation.h>
#import <net/if.h>
#import "FGRoute.h"

@implementation foreamCamCtrl


static foreamCamCtrl *instance = nil;

- (id) init
{
    self = [super init];
    if (self) {
        NSLog(@"foream Cam Ctrl Init");
    }
    [self initData];
//    [self setupSocket];
    return  self;
}

+ (foreamCamCtrl *)getInstance
{
    @synchronized(self)
    {
        if (!instance)
        {
            instance = [[foreamCamCtrl alloc] init];
            
        }
        return instance;
    }
    return  nil;
}

-(void)initData
{
    _onlineCamList = [[NSMutableArray alloc]init];
    
}

-(void)clearAllData
{
    [_onlineCamList removeAllObjects];
}

-(void)setupSocket
{
    //初始化发送socket
    GCDAsyncUdpSocket *socket = [[GCDAsyncUdpSocket alloc] initWithDelegate:self delegateQueue:dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0)];
    
    NSError *error = nil;
    
    //绑定本地端口
    [socket bindToPort:5555 error:&error];
    
    if (error) {
        NSLog(@"1:%@",error);
        return;
    }
    
    //启用广播
    [socket enableBroadcast:YES error:&error];
    
    if (error) {
        NSLog(@"2:%@",error);
        return;
    }
    
    //开始接收数据(不然会收不到数据)
    //    [socket beginReceiving:&error];
    
    if (error) {
        NSLog(@"3:%@",error);
        return;
    }
    
    _sendSocket = socket;
    
    //初始化接收socket
//    socket = [[GCDAsyncUdpSocket alloc] initWithDelegate:self delegateQueue:dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0)];
//
//    //    NSError *error = nil;
//
//    //绑定本地端口
//    [socket bindToPort:5555 error:&error];
//
//    if (error) {
//        NSLog(@"1:%@",error);
//        return;
//    }
//
//    //启用广播
//    //    [socket enableBroadcast:YES error:&error];
//
//    if (error) {
//        NSLog(@"2:%@",error);
//        return;
//    }
//
//    //开始接收数据(不然会收不到数据)
//    //    [socket beginReceiving:&error];
//
//    if (error) {
//        NSLog(@"3:%@",error);
//        return;
//    }
//
//    _sendSocket = socket;
    
}

//开启监听
-(void)startListener
{
    [self setupSocket];
    NSError *error = nil;
    
    if(_sendSocket!=nil)
        [_sendSocket beginReceiving:&error];
}

//停止监听
-(void)stopListener
{
    if(_sendSocket!=nil)
    {
        [_sendSocket pauseReceiving];
        [_sendSocket close];
    }
}

//开启扫描
-(void)startScan
{
    //发送广播
    if(_sendSocket!=nil)
    {
        NSString *msg = @"CAM";
        _bScaning = YES;
//        [_onlineCamList removeAllObjects];
        [_sendSocket sendData:[msg dataUsingEncoding:NSUTF8StringEncoding] toHost:[self getBoardcastAddress] port:5555 withTimeout:10 tag:100];
        if(_scanOnlineCamtimer!=nil)
        {
            [_scanOnlineCamtimer invalidate];
            _scanOnlineCamtimer = nil;
        }
        _scanOnlineCamtimer = [NSTimer scheduledTimerWithTimeInterval:3 target:self selector:@selector(updateCamOnline) userInfo:nil repeats:NO];
    }
}

//关闭扫描
-(void)stopScan
{
    _bScaning = NO;
    if(_scanOnlineCamtimer!=nil)
    {
        [_scanOnlineCamtimer invalidate];
        _scanOnlineCamtimer = nil;
    }
}

-(void)updateCamOnline
{
    _bScaning = NO;
    if ([_delegate respondsToSelector:@selector(updateNumberOfCamOnline:)]) {
        [_delegate updateNumberOfCamOnline:_onlineCamList];
    }
}

-(NSString *)generateQRCode:(NSString *) ssid password:(NSString *)pwd streamType:(NSString *) streamType
{
    NSString *qrCodeString  = nil;
    //NSString *ipAddress = [self getIPAddress];
    
//    NSString *encodedSSID = (__bridge NSString *)CFURLCreateStringByAddingPercentEscapes( NULL, (__bridge CFStringRef)ssid, NULL, (CFStringRef)@"!*'();:@&=+$,/?%#[]", kCFStringEncodingUTF8 );
    //二维码格式为 1｜ssid|password|phone_ip|stream_type
    //qrCodeString = [NSString stringWithFormat:@"4|%@|%@|%@|%@",ssid, pwd, ipAddress,streamType];

    //二维码格式为: "17|router_ssid|router_password|stream_Type"
    qrCodeString = [NSString stringWithFormat:@"17|%@|%@|%@",ssid, pwd,streamType];
    return qrCodeString;
}

-(NSString *)getBoardcastAddress
{
    NSString *boardcastAddress = @"255.255.255.255";
    NSString *ipAddress = [self getIPAddress];
    if(![ipAddress isEqualToString:@""])
    {
        NSArray *array = [ipAddress componentsSeparatedByString:@"."];
        boardcastAddress = [NSString stringWithFormat:@"%@.%@.%@.%@", [array objectAtIndex:0], [array objectAtIndex:1], [array objectAtIndex:2], @"255"];
    }
    return boardcastAddress;
}

- (void)udpSocket:(GCDAsyncUdpSocket *)sock didSendDataWithTag:(long)tag
{
    
}

- (void)udpSocket:(GCDAsyncUdpSocket *)sock didNotSendDataWithTag:(long)tag dueToError:(NSError *)error
{
    
}

- (void)udpSocket:(GCDAsyncUdpSocket *)sock didReceiveData:(NSData *)data fromAddress:(NSData *)address withFilterContext:(id)filterContext
{
    NSString *msg = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
    NSString *host = [GCDAsyncUdpSocket hostFromAddress:address];
    if([host containsString:@"::ffff:"])
        return;
    NSString *iPAdress = [host componentsSeparatedByString:@"::ffff:"].lastObject;//
    NSLog(@"kc test: msg is %@", msg);
    //判断包类型
    
    if([msg containsString:@"|"])
    {//只处理包含"|"的包,包格式为 "5|25KVQGNAAAA5QG00|GHOST_4K+|OwnerId|RTMP"
        NSArray *array = [msg componentsSeparatedByString:@"|"];
        NSString *type = [array objectAtIndex:0];
        if(type.integerValue == 1 )
        {//查询包
//            if(_bScaning)
            {
                camInfo *info = [camInfo new];
                info.ipAddress = iPAdress;
                info.searialNumber = [array objectAtIndex:1];
                info.modelName = [array objectAtIndex:2];
                info.fw_version = [array objectAtIndex:3];

                if(![self checkIfExist:info.searialNumber])
                {
                    [_onlineCamList addObject:info];
                }
            }
        }
        else if(([array count]==5) && (type.integerValue == 5))
        {//心跳包的数据数需要是5
            NSString *camSearial = [array objectAtIndex:1];
            NSString *camId = [NSString stringWithFormat:@"%@_%@",[array objectAtIndex:2], [camSearial substringWithRange:NSMakeRange(camSearial.length-1-5, 6)]];
            NSString *ownerId = [array objectAtIndex:3];
            NSString *msgValue = [array objectAtIndex:4];
            
            if ([_delegate respondsToSelector:@selector(camIsOnline:MsgValue:CamIP:OwnerId:)]) {
                [_delegate camIsOnline:camId MsgValue:msgValue CamIP:iPAdress OwnerId:ownerId];
            }
        }
    }
}

-(BOOL)checkIfExist:(NSString *) value
{
    for(int i = 0; i < _onlineCamList.count; i ++)
    {
        camInfo *info = [_onlineCamList objectAtIndex:i];
        if([info.searialNumber isEqualToString:value])
        {
            return YES;
        }
    }
    return NO;
}

-(NSString *)getIPAddress
{
    
    NSString *address = @"";
    
    struct ifaddrs *interfaces = NULL;
    
    struct ifaddrs *temp_addr = NULL;
    
    int success = 0;
    
    success = getifaddrs(&interfaces);
    
    if (success == 0) { // 0 表示获取成功
        
        temp_addr = interfaces;
        
        while (temp_addr != NULL) {
            
            if( temp_addr->ifa_addr->sa_family == AF_INET) {
                
                // Check if interface is en0 which is the wifi connection on the iPhone
                
                if ([[NSString stringWithUTF8String:temp_addr->ifa_name] isEqualToString:@"en0"]) {
                    
                    // Get NSString from C String
                    
                    address = [NSString stringWithUTF8String:inet_ntoa(((struct sockaddr_in *)temp_addr->ifa_addr)->sin_addr)];
                    
                }
            }
            temp_addr = temp_addr->ifa_next;
        }
    }
    
    freeifaddrs(interfaces);
    
    return address;
    
}

//- (NSString *)fetchSSIDName {
//    NSArray *ifs = (__bridge_transfer id)CNCopySupportedInterfaces();
//    id info = nil;
//    NSString *ssidName = nil;
//    for (NSString *ifnam in ifs) {
//        info = (__bridge_transfer id)CNCopyCurrentNetworkInfo((__bridge CFStringRef)ifnam);
//        if([info count])
//        {
//            ssidName = (NSString *)CFDictionaryGetValue ((__bridge CFDictionaryRef)(info), kCNNetworkInfoKeySSID);
//            if (info && [info count]) { break; }
//        }
//    }
//    return ssidName;
//}

//fetch current ssid info
- (NSString *)fetchSSIDName {
    if (@available(iOS 13.0, *)) {
        //用户明确拒绝，可以弹窗提示用户到设置中手动打开权限
        if ([CLLocationManager authorizationStatus] == kCLAuthorizationStatusDenied) {
            NSLog(@"User has explicitly denied authorization for this application, or location services are disabled in Settings.");
            //使用下面接口可以打开当前应用的设置页面
            //[[UIApplication sharedApplication] openURL:[NSURL URLWithString:UIApplicationOpenSettingsURLString]];
            return nil;
        }
        CLLocationManager* cllocation = [[CLLocationManager alloc] init];
        if(![CLLocationManager locationServicesEnabled] || [CLLocationManager authorizationStatus] == kCLAuthorizationStatusNotDetermined){
            //弹框提示用户是否开启位置权限
            [cllocation requestWhenInUseAuthorization];
            usleep(500);
            //递归等待用户选选择
            return [self fetchSSIDName];
        }
    }
    NSString *wifiName = [FGRoute getSSID]; // Connected wifi name
//    CFArrayRef wifiInterfaces = CNCopySupportedInterfaces();
//    if (!wifiInterfaces) {
//        return nil;
//    }
//    NSArray *interfaces = (__bridge NSArray *)wifiInterfaces;
//    for (NSString *interfaceName in interfaces) {
//        CFDictionaryRef dictRef = CNCopyCurrentNetworkInfo((__bridge CFStringRef)(interfaceName));
//
//        if (dictRef) {
//            NSDictionary *networkInfo = (__bridge NSDictionary *)dictRef;
//            NSLog(@"network info -> %@", networkInfo);
//            wifiName = [networkInfo objectForKey:(__bridge NSString *)kCNNetworkInfoKeySSID];
//            CFRelease(dictRef);
//        }
//    }
//
//    CFRelease(wifiInterfaces);
    return wifiName;

}

- (BOOL) isWiFiEnabled {
    NSCountedSet * cset = [NSCountedSet new];
    struct ifaddrs *interfaces;
    if( ! getifaddrs(&interfaces) )
    {
        for( struct ifaddrs *interface = interfaces; interface; interface = interface->ifa_next)
        {
            if ( (interface->ifa_flags & IFF_UP) == IFF_UP )
            {
                [cset addObject:[NSString stringWithUTF8String:interface->ifa_name]];
            }
        }
    }
    return [cset countForObject:@"awdl0"] > 1 ? YES : NO;
}
@end
