//
//  camScanListViewController.m
//  foreamApiDemo
//
//  Created by kc.chen on 11/04/2018.
//  Copyright © 2018 kc.chen. All rights reserved.
//

#import "camScanListViewController.h"
#import "camInfoTableViewCell.h"
#import "camInfo.h"
#import "foreamCamCtrl.h"
@interface camScanListViewController ()

@end

@implementation camScanListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    onlineCamList = [[NSMutableArray alloc]init];
    checkOnlineCamTimer = [NSTimer scheduledTimerWithTimeInterval:5 target:self selector:@selector(scanCamOnline) userInfo:nil repeats:YES];
    [foreamCamCtrl getInstance].delegate = self;
    //先清空数据
    [[foreamCamCtrl getInstance] clearAllData];
}

-(void)viewWillAppear:(BOOL)animated
{
    [self setupObservers];
    [[foreamCamCtrl getInstance] startListener];
    [[foreamCamCtrl getInstance] startScan];

    if(![[foreamCamCtrl getInstance] isWiFiEnabled])
    {
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"消息提醒" message:@"请打开Wi-Fi" preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:^(UIAlertAction *action) {
            [self dismissViewControllerAnimated:YES completion:^{}];
        }];
        
        [alertController addAction:cancelAction];
        [self presentViewController:alertController animated:YES completion:nil];
        
    }
    [super viewWillAppear:animated];
}

-(void)viewWillDisappear:(BOOL)animated
{
    [self unSetupObservers];
    [[foreamCamCtrl getInstance] stopListener];
    [[foreamCamCtrl getInstance] stopScan];
    [checkOnlineCamTimer invalidate];
    checkOnlineCamTimer = nil;
    [super viewWillDisappear:animated];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)setupObservers
{
    NSNotificationCenter *def = [NSNotificationCenter defaultCenter];
    [def addObserver:self
            selector:@selector(applicationDidEnterForeground:)
                name:UIApplicationDidBecomeActiveNotification
              object:[UIApplication sharedApplication]];
    [def addObserver:self
            selector:@selector(applicationDidEnterBackground:)
                name:UIApplicationWillResignActiveNotification
              object:[UIApplication sharedApplication]];
}

- (void)unSetupObservers
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)applicationDidEnterForeground:(NSNotification *)notification
{
    [[foreamCamCtrl getInstance] startListener];
}

- (void)applicationDidEnterBackground:(NSNotification *)notification
{
    [[foreamCamCtrl getInstance] stopListener];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

-(IBAction)refresh:(id)sender
{
    [[foreamCamCtrl getInstance] startScan];
}


-(IBAction)returnToMainView:(id)sender{
    
    [self dismissViewControllerAnimated:YES completion:^{}];
}

#pragma mark - foreamCamCtrlDelegate
- (void)camIsOffline:(NSString *)camSearial
{
    
    
}

- (void)camIsOnline:(NSString *)camSearial
{
    
    
}

- (void)updateNumberOfCamOnline:(NSMutableArray *)scanOnlineCamList
{
//    [onlineCamList removeAllObjects];
//    [onlineCamList addObjectsFromArray:scanOnlineCamList];
//    dispatch_async(dispatch_get_main_queue(), ^{
//        [tableView reloadData];
//    });
    [self updateCamOnlineStatus:scanOnlineCamList];
}

#pragma mark - UITableViewDelegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return onlineCamList.count;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 70;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    camInfoTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"camInfoTableViewCell"];
    if (cell == nil) {
        cell = [[camInfoTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"camInfoTableViewCell"];
        
    }

    if(![onlineCamList count])
        return cell;
    camInfo *info = [onlineCamList objectAtIndex:indexPath.row];
//    if([info.modelName containsString:@"X1"])
        [cell.modelImage setImage:[UIImage imageNamed:@"Cam_live_X1_new"]];
//    else
//        [cell.modelImage setImage:[UIImage imageNamed:@"Connect_ghost4k"]];
    
    cell.camIpAddress.text = info.ipAddress;
    cell.modelName.text = info.modelName;
    cell.camSearialNum.text = info.searialNumber;
    cell.camVersion.text = info.fw_version;
    return cell;
}

-(void)scanCamOnline
{
    [[foreamCamCtrl getInstance] startScan];
}

-(void)updateCamOnlineStatus:(NSMutableArray *)scanOnlineCamList
{
    if([onlineCamList count])
    {//与搜索到的相机列表做对比
        for(int i=0; i<[onlineCamList count]; i++)
        {
            camInfo *info = [onlineCamList objectAtIndex:i];
//            if([scanOnlineCamList indexOfObject:info]== NSNotFound)
            NSPredicate *predicate = [NSPredicate predicateWithFormat:@"searialNumber == %@", info.searialNumber];
            NSArray *filteredArray = [scanOnlineCamList filteredArrayUsingPredicate:predicate];
            if(![filteredArray count])
            {
                UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"消息提醒" message:[NSString stringWithFormat:@"相机%@已下线", info.searialNumber] preferredStyle:UIAlertControllerStyleAlert];
                UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:^(UIAlertAction *action) {
                }];
                
                [alertController addAction:cancelAction];
                [self presentViewController:alertController animated:YES completion:nil];
                
            }
        }
    }
    [onlineCamList removeAllObjects];
    [onlineCamList addObjectsFromArray:scanOnlineCamList];
    dispatch_async(dispatch_get_main_queue(), ^{
        [tableView reloadData];
    });
    
}
@end
