//
//  qrCodeScanViewController.m
//  foreamApiDemo
//
//  Created by kc.chen on 11/04/2018.
//  Copyright © 2018 kc.chen. All rights reserved.
//

#import "qrCodeScanViewController.h"
#import "AppDelegate.h"
//#import "HTQRCodeCreater.h"
#import "foreamCamCtrl.h"
#import "QRCodeGenerator.h"
@interface qrCodeScanViewController ()

@end

@implementation qrCodeScanViewController
@synthesize qrCodeString;
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
//    qrCodeString = [APPDELEGATE qrCodeString];
//    NSLog(@"kc test: 传递过来的数据是:%@", qrCodeString);
//    HTQRCodeCreater *qrCreater = [[HTQRCodeCreater alloc] init];
//    qrImage.image = [qrCreater createQRCodeWithUrlString:qrCodeString qRCodeSize:qrImage.bounds.size.width centerLogo:nil logoSize:0];
    qrCodeString = [[foreamCamCtrl getInstance] generateQRCode:[APPDELEGATE ssid] password:[APPDELEGATE pwd] streamType:[APPDELEGATE streamType]];
    qrValue.text = qrCodeString;
    qrImage.image = [QRCodeGenerator qrImageForString:qrCodeString imageSize:qrImage.bounds.size.width];
    
    if([[APPDELEGATE streamType] isEqualToString:@"tcp"])
    {
        [switchBtn setTitle:@"切换成rtsp" forState: UIControlStateNormal];
    }
    else
    {
       [switchBtn setTitle:@"切换成tcp" forState: UIControlStateNormal];
    }
    //开始接收数据
    [foreamCamCtrl getInstance].delegate = self;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self setupObservers];
    [[foreamCamCtrl getInstance] startListener];
}

-(void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self unSetupObservers];
    [[foreamCamCtrl getInstance] stopListener];
}

- (void)setupObservers
{
    NSNotificationCenter *def = [NSNotificationCenter defaultCenter];
    [def addObserver:self
            selector:@selector(applicationDidEnterForeground:)
                name:UIApplicationDidBecomeActiveNotification
              object:[UIApplication sharedApplication]];
    [def addObserver:self
            selector:@selector(applicationDidEnterBackground:)
                name:UIApplicationWillResignActiveNotification
              object:[UIApplication sharedApplication]];
}

- (void)unSetupObservers
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)applicationDidEnterForeground:(NSNotification *)notification
{
    [[foreamCamCtrl getInstance] startListener];
}

- (void)applicationDidEnterBackground:(NSNotification *)notification
{
    [[foreamCamCtrl getInstance] stopListener];
}

//-(IBAction)returnToMainView:(id)sender{
//
//    [self dismissViewControllerAnimated:YES completion:^{}];
//}

-(IBAction)switcgStreamType:(id)sender{
    
    if([[APPDELEGATE streamType] isEqualToString:@"tcp"])
    {
        [APPDELEGATE setStreamType:@"rtsp"];
        [switchBtn setTitle:@"切换成tcp" forState: UIControlStateNormal];
    }
    else
    {
        [APPDELEGATE setStreamType:@"tcp"];
        [switchBtn setTitle:@"切换成rtsp" forState: UIControlStateNormal];
    }
    
    dispatch_async(dispatch_get_main_queue(), ^{
        qrCodeString = [[foreamCamCtrl getInstance] generateQRCode:[APPDELEGATE ssid] password:[APPDELEGATE pwd] streamType:[APPDELEGATE streamType]];
        qrValue.text = qrCodeString;
        qrImage.image = [QRCodeGenerator qrImageForString:qrCodeString imageSize:qrImage.bounds.size.width];
    });
    
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (void)camIsOffline:(NSString *)camSearial
{
    dispatch_async(dispatch_get_main_queue(), ^{
        status.text = [NSString stringWithFormat: @"%@已离线", camSearial];
    });

}

//- (void)camIsOnline:(NSString *)camSearial
//{
//    dispatch_async(dispatch_get_main_queue(), ^{
//        status.text = [NSString stringWithFormat: @"%@已上线", camSearial];
//    });
//}

- (void)camIsOnline:(NSString *)camSearial MsgValue:(NSString *) msgValue  CamIP:(NSString *) camIP OwnerId:(NSString *) ownerId
{
    dispatch_async(dispatch_get_main_queue(), ^{
        status.text = [NSString stringWithFormat: @"%@已上线, ip是: %@", camSearial, camIP];
    });
}

- (void)updateNumberOfCamOnline:(NSMutableArray *)scanOnlineCamList
{
    
}

@end
