//
//  ControlViewController.m
//  CamControlDemo
//
//  Created by kc chen on 2022/2/27.
//

#import "ControlViewController.h"
#import "CameraCmdApi.h"
#import "UrlPathConfig.h"
#import "KissXML.h"
#import "CamSetting.h"
#import "MacroDefinition.h"

@interface ControlViewController ()
{
    CamSetting *camSetting;
    BOOL isInit;
}

@property (weak, nonatomic) IBOutlet UITextField *IPTextField;
@property (weak, nonatomic) IBOutlet UISlider *zoomSlider;
@property (weak, nonatomic) IBOutlet UISlider *expoSlider;
@property (weak, nonatomic) IBOutlet UISlider *micSlider;
@property (weak, nonatomic) IBOutlet UISlider *filterSlider;
@property (weak, nonatomic) IBOutlet UISwitch *ledSwitch;
@property (weak, nonatomic) IBOutlet UILabel *resLabel;
@property (weak, nonatomic) IBOutlet UIButton *resButton;
@property (weak, nonatomic) IBOutlet UILabel *fpsLabel;
@property (weak, nonatomic) IBOutlet UIButton *fpsButton;
@property (weak, nonatomic) IBOutlet UIButton *startRecButton;
@property (weak, nonatomic) IBOutlet UIButton *stopRecButton;
@property (weak, nonatomic) IBOutlet UIButton *rebootButton;
@property (weak, nonatomic) IBOutlet UIButton *shutdownButton;
@property (nonatomic, strong) NSString *camIP;
@end

@implementation ControlViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    isInit = NO;
    [_zoomSlider addTarget:self action:@selector(sliderValurChanged:forEvent:)forControlEvents:UIControlEventValueChanged];
    [_expoSlider addTarget:self action:@selector(sliderValurChanged:forEvent:)forControlEvents:UIControlEventValueChanged];
    [_micSlider addTarget:self action:@selector(sliderValurChanged:forEvent:)forControlEvents:UIControlEventValueChanged];
    [_filterSlider addTarget:self action:@selector(sliderValurChanged:forEvent:)forControlEvents:UIControlEventValueChanged];
    [_ledSwitch addTarget:self action:@selector(switchAction:)forControlEvents:UIControlEventValueChanged];
    _camIP = _IPTextField.text;
//    [self getCamSetting];
    [self getCamStatus];
}

#pragma mark Button Action
- (IBAction)backAction:(id)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

-(void)sliderValurChanged:(UISlider*)slider forEvent:(UIEvent*)event {

    UITouch* touchEvent = [[event allTouches]anyObject];

    switch(touchEvent.phase) {

//    case UITouchPhaseBegan:
//        DLog(@"开始拖动");
//        break;
//
//    case UITouchPhaseMoved:
//        DLog(@"正在拖动");
//        break;

    case UITouchPhaseEnded:
    {
        int value = slider.value;
        DLog(@"结束拖动=%d tag is %ld",value, (long)slider.tag);
        switch(slider.tag)
        {
            case 0:
            {
                [self setZoom:value];
                break;
            }
            case 1:
            {
                [self setExpo:value];
                break;
            }
            case 2:
            {
                [self setMic:value];
                break;
            }
            case 3:
            {
                [self setFilter:value];
                break;
            }
            default:
                break;
        }
    }

     break;

    default:

      break;

    }
}

-(void)switchAction:(id)sender {
    
    [self setLED:_ledSwitch.isOn];
}

- (IBAction)getCamSettingAction:(id)sender {
    [self getCamSetting];
}

- (IBAction)startRecordAction:(id)sender {
    [self startRecord];
}

- (IBAction)stopRecordAction:(id)sender {
    [self stopRecord];
}

- (IBAction)rebootAction:(id)sender {
    [self reboot];
}

- (IBAction)shutdownAction:(id)sender {
    [self shutdown];
}

- (IBAction)switchResAction:(id)sender {
    [self switchRes];
}

- (IBAction)switchFpsAction:(id)sender {
    [self switchFPS];
}

#pragma mark API Method
-(void)setZoom:(int)value {
    if(!isInit) return;
    
    NSString *command= [NSString stringWithFormat:ForeamLocaZoomCmd,_camIP,value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
}

-(void)setExpo:(int)value {
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalExposureCmd,_camIP,value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
}

-(void)setMic:(int)value {
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalMicCmd,_camIP,value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
}

-(void)setFilter:(int)value {
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalFilterCmd,_camIP, value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
}

-(void)setLED:(BOOL)isOn{
    if(!isInit) return;

    int value = isOn?1:0;
    NSString *command= [NSString stringWithFormat:ForeamLocalLEDCmd,_camIP, value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
}

-(void)startRecord
{
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalStartRecCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
           {
               
               DLog(@"responseString %@",request.responseString);
           
           } failure:^(__kindof YTKBaseRequest * _Nonnull request)
           {
               
           }
    ];
    
}

-(void)stopRecord
{
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalStopRecCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
    
    
}

-(void)reboot
{
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalStopRecCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
    
}

-(void)shutdown
{
    if(!isInit) return;

    NSString *command= [NSString stringWithFormat:ForeamLocalStopRecCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
    
}

-(void)switchRes
{
    if(!isInit) return;

    /*
     VRES_1080P,   //3
     VRES_720P,    //4
     VRES_WVGA,    //5
     */
    int value = camSetting.stream_res;
    if(value==3)
    {
        value = 4;
    }
    else if(value==4)
    {
        value = 5;
    }
    else
    {
        value = 3;
    }
    NSString *command= [NSString stringWithFormat:ForeamLocalStreamResCmd,_camIP, value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
    {
        DLog(@"responseString %@",request.responseString);
        self->camSetting.stream_res = value;
        [self updateResDisplay];
        
    } failure:^(__kindof YTKBaseRequest * _Nonnull request)
    {
       
    }];
}

-(void)switchFPS
{
    if(!isInit) return;

    int value = 1;
    if(camSetting.stream_framerate == 25)
        value = 2;
    else
        value = 1;
        
    NSString *command= [NSString stringWithFormat:ForeamLocalStreamFpsCmd ,_camIP, value];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
    {
        DLog(@"responseString %@",request.responseString);
        if(value == 2)
            self->camSetting.stream_framerate = 30;
        else
            self->camSetting.stream_framerate = 25;
        [self updateFpsDisplay];
        
    } failure:^(__kindof YTKBaseRequest * _Nonnull request)
    {
       
    }];
    
}


-(void)getCamSetting
{
    _camIP = _IPTextField.text;
    if(_camIP.length == 0)
        return;
    
    NSString *command= [NSString stringWithFormat:ForeamLocalGetCamSettingCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
      [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
                   {

                        DLog(@"responseString %@",request.responseString);
                        DDXMLDocument *xmlDoc = [[DDXMLDocument alloc]initWithXMLString:[request responseString] options:0 error:nil];
                        NSArray *settingInfo = [xmlDoc nodesForXPath:@"//Setting" error:nil];

                        self->camSetting = [CamSetting new];

                        for (DDXMLElement *devInfoNode in settingInfo) {

                          NSString *stream_resStr = [[devInfoNode elementForName:@"stream_res"] stringValue];
//                          int stream_res = 2;
//                          if([stream_resStr isEqual:@"720P"])
//                          {
//                              stream_res = 1;
//                          }else if([stream_resStr isEqual:@"1080P"])
//                          {
//                              stream_res = 0;
//                          }else
//                          {
//                              stream_res = 2;
//                          }

                            [self->camSetting setStream_res:[stream_resStr intValue]];
                            [self->camSetting setStream_bitrate:[[[devInfoNode elementForName:@"stream_bitrate"] stringValue] intValue]];
                            [self->camSetting setStream_framerate:[[[devInfoNode elementForName:@"stream_framerate"] stringValue] intValue]];
                            [self->camSetting setDzoom:[[[devInfoNode elementForName:@"dzoom"] stringValue] intValue]];
                            [self->camSetting setFilter:[[[devInfoNode elementForName:@"filter"] stringValue] intValue]];
                            [self->camSetting setExposure:[[[devInfoNode elementForName:@"exposure"] stringValue] intValue]];
                            [self->camSetting setMic:[[[devInfoNode elementForName:@"mic"] stringValue] intValue]];
                            [self->camSetting setLed:[[[devInfoNode elementForName:@"led"] stringValue] intValue]];
                            self->isInit = YES;
                            [self updateControlerDisplay];
                        }
//                        DLog(@"dfift test: camSetting.stream_res is %d", self->camSetting.stream_res);


                   } failure:^(__kindof YTKBaseRequest * _Nonnull request)
                   {

                   }];
    
}

-(void)getCamStatus
{
    _camIP = _IPTextField.text;
    if(_camIP.length == 0)
        return;
    
    NSString *command= [NSString stringWithFormat:ForeamLocalGetCamStatusCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
      [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
                   {

                        DLog(@"responseString %@",request.responseString);
                   } failure:^(__kindof YTKBaseRequest * _Nonnull request)
                   {

                   }
      ];
    
}

#pragma mark UI Related Method
-(void)updateControlerDisplay
{
    _zoomSlider.value = camSetting.dzoom;
    _expoSlider.value = camSetting.exposure;
    _micSlider.value = camSetting.mic;
    _filterSlider.value = camSetting.filter;
    [_ledSwitch setOn:camSetting.led];
    [self updateResDisplay];
    [self updateFpsDisplay];
}

-(void)updateResDisplay
{
    if(camSetting.stream_res == 3)
        _resLabel.text = @"1080P";
    else if(camSetting.stream_res == 4)
        _resLabel.text = @"720P";
    else
        _resLabel.text = @"WVGA";
}

-(void)updateFpsDisplay
{
    _fpsLabel.text = [NSString stringWithFormat:@"%d",camSetting.stream_framerate];
}

@end
