//
//  FileViewController.m
//  CamControlDemo
//
//  Created by kc chen on 2022/2/27.
//

#import "FileViewController.h"
#import "FileInfoCell.h"
#import "CameraCmdApi.h"
#import "UrlPathConfig.h"
#import "KissXML.h"
#import "MacroDefinition.h"
#import "JSONKit.h"
#import "WDPhotoInfo.h"

@interface FileViewController ()
{
    NSMutableArray *foldersData;
    NSMutableArray *filseData;
    int folderIndex;
}
@property (weak, nonatomic) IBOutlet UIButton *getFilesButton;
@property (weak, nonatomic) IBOutlet UITextField *IPTextField;
@property (weak, nonatomic) IBOutlet UICollectionView *collectionView;
@property (nonatomic, strong) NSString *camIP;


@end

@implementation FileViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    UINib *nib = [UINib nibWithNibName:@"FileInfoCell" bundle:nil];
    [self.collectionView registerNib:nib forCellWithReuseIdentifier:@"FileInfoCell"];
    _camIP = _IPTextField.text;
    foldersData = [[NSMutableArray alloc] init];
    filseData = [[NSMutableArray alloc] init];
}

#pragma mark Button Action
- (IBAction)backAction:(id)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)getFilesAction:(id)sender {
    [self getCamFolder];
}

#pragma mark - UICollectionView Datasource
- (NSInteger)collectionView:(UICollectionView *)view numberOfItemsInSection:(NSInteger)section;
{
    return [filseData count];
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return 1;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)cv cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    FileInfoCell *cell = [cv dequeueReusableCellWithReuseIdentifier:@"FileInfoCell" forIndexPath:indexPath];
    WDPhotoInfo *fileInfo = [filseData objectAtIndex:indexPath.row];
    cell.size.text = fileInfo.size;
    cell.fileName.text = fileInfo.file_name;
    cell.date.text = fileInfo.creat_time;
    return cell;
}

#pragma mark - UICollectionViewDelegate

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
//    if ([_delegate respondsToSelector:@selector(deleteFriendAtIndex:)]) {
//        [_delegate deleteFriendAtIndex:indexPath.row];
//    }
}

-(void)getCamFolder
{
    _camIP = _IPTextField.text;
    if(!_camIP)
        return;
    
    NSString *command= [NSString stringWithFormat:ForeamLocalListFoldersCmd,_camIP];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
           DLog(@"responseString %@",request.responseString);
            DDXMLDocument *xmlDoc = [[DDXMLDocument alloc]initWithXMLString:[request responseString] options:0 error:nil];
            NSArray *responseInfo = [xmlDoc nodesForXPath:@"//Response" error:nil];
            int amount = 0;
            for (DDXMLElement *infoNode in responseInfo) {
                amount = [[[infoNode elementForName:@"Amount"]  stringValue] intValue];
                if(amount>0)
                {
                    [self->foldersData removeAllObjects];
                    [self->filseData removeAllObjects];
                    NSString *folderStr = [[infoNode elementForName:@"Folders"]  stringValue];
                    folderStr = [NSString stringWithFormat:@"[%@]", [folderStr substringToIndex:(folderStr.length-1)]];
                    NSMutableArray *foldersArray = [folderStr objectFromJSONStringWithParseOptions:JKParseOptionLooseUnicode];
                    for (id dInfo in foldersArray){
                        NSString *folderName = [dInfo objectForKey:@"Path"];
                        DLog(@"drift test: folderName is %@", folderName);
                        [self->foldersData addObject:folderName];
                    }
                    
                    self->folderIndex = 0;
                    [self getCamFilesInFolder:self->folderIndex];

                }
            }
        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
    
}

-(void)getCamFilesInFolder:(int) index
{
    _camIP = _IPTextField.text;
    if(!_camIP)
        return;
    
    NSString *folderName = [foldersData objectAtIndex:index];
    
    NSString *command= [NSString stringWithFormat:ForeamLocalListFilseCmd,_camIP, folderName];
    CameraCmdApi *cameraCmdApi = [[CameraCmdApi alloc] initWithCommandUrl:command];
    [cameraCmdApi startWithCompletionBlockWithSuccess:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
         DLog(@"responseString %@",request.responseString);
         DDXMLDocument *xmlDoc = [[DDXMLDocument alloc]initWithXMLString:[request responseString] options:0 error:nil];
         NSArray *responseInfo = [xmlDoc nodesForXPath:@"//Response" error:nil];
         int amount = 0;
         for (DDXMLElement *infoNode in responseInfo) {
             amount = [[[infoNode elementForName:@"Amount"]  stringValue] intValue];
             if(amount>0)
             {
                 NSString *fileStr = [[infoNode elementForName:@"Files"]  stringValue];
                 fileStr = [NSString stringWithFormat:@"[%@]", [fileStr substringToIndex:(fileStr.length-1)]];
                 NSMutableArray *filesArray = [fileStr objectFromJSONStringWithParseOptions:JKParseOptionLooseUnicode];
                 NSString *folderName = [self->foldersData objectAtIndex:self->folderIndex];

                 for (id dInfo in filesArray){
                    NSString *fileName = [dInfo objectForKey:@"Path"];
                    NSString *createTime = [dInfo objectForKey:@"CreateTime"];
                    NSString *size = [dInfo objectForKey:@"Size"];
                    NSString *thumb = [dInfo objectForKey:@"Thumb"];
                    DLog(@"drift test: fileName is %@, createTime is %@, size is %@, thumb is %@, ", fileName, createTime, size, thumb);
                     
                    WDPhotoInfo *fileInfo = [[WDPhotoInfo alloc]init];
                    fileInfo.file_name = fileName;
                    fileInfo.size = [NSString stringWithFormat:@"%dM",[size intValue]/1024/1024];

                     NSDictionary * Monthdic = [[NSDictionary alloc]initWithObjectsAndKeys:
                        @"01",   @"Jan",
                        @"02",   @"Feb",
                        @"03",   @"Mar",
                        @"04",   @"Apr",
                        @"05",   @"May",
                        @"06",   @"Jun",
                        @"07",   @"Jul",
                        @"08",   @"Aug",
                        @"09",   @"Sep",
                        @"10",   @"Oct",
                        @"11",   @"Nov",
                        @"12",   @"Dec",
                        nil];
                     //"Apr 02 17:26:52 2021"
                    NSArray *dateArr = [createTime componentsSeparatedByString:@" "];
                    NSString *monthStr = [Monthdic objectForKey:[dateArr objectAtIndex:0]];
                    NSString *dayStr = [dateArr objectAtIndex:1];
                    NSString *timeStr = [dateArr objectAtIndex:2];
                    NSString *yearStr = [dateArr objectAtIndex:3];

                    fileInfo.creat_time = [NSString stringWithFormat:@"%@-%@-%@ %@", yearStr, monthStr,dayStr,timeStr];
                     
                     fileInfo.downloadUrl = [NSString stringWithFormat:@"http://%@/DCIM/%@/%@", self->_camIP, folderName, fileName];
                     [self->filseData addObject:fileInfo];
                 }
                 if(self->folderIndex<[self->foldersData count]-1)
                 {
                     self->folderIndex++;
                     [self getCamFilesInFolder:self->folderIndex];
                 }
                 else
                 {
                     NSSortDescriptor *sortDescriptor1 = [[NSSortDescriptor alloc] initWithKey:@"creat_time" ascending:NO];
                     [self->filseData sortUsingDescriptors:[NSArray arrayWithObject:sortDescriptor1]];
                     dispatch_async(dispatch_get_main_queue(), ^{
                         [self->_collectionView reloadData];
                     });
                 }
             }
         }

        } failure:^(__kindof YTKBaseRequest * _Nonnull request)
        {
           
        }
    ];
    
}



@end
