package com.foream.demo;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.foream.api.CamInfo;

import java.util.ArrayList;

/**
 * Created by admin on 2017/11/6.
 */

public class CamRecyclerViewAdapter extends RecyclerView.Adapter<CamRecyclerViewAdapter.ViewHolder>  {
    private android.support.v4.util.ArrayMap<String, CamInfo> m_camList;
    private Context m_mContext;
    public int selectPos = -1;
    public CamRecyclerViewAdapter(Context context, android.support.v4.util.ArrayMap<String, CamInfo> camList) {
        m_mContext = context;
        m_camList = camList;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(m_mContext).inflate(R.layout.item_cam, parent, false);
        ViewHolder viewHolder = new ViewHolder(v);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder,final int position) {
        CamInfo info = m_camList.valueAt(position);
        holder.tvFwversion.setText(info.getFw_version());
        holder.tvIpaddress.setText(info.getIpAddress());
        holder.tvModelname.setText(info.getModelName());
        holder.tvSerialnumber.setText(info.getSerialNumber());
    }

    @Override
    public int getItemCount() {
        return m_camList.size();
    }

    protected class ViewHolder extends RecyclerView.ViewHolder {
        private ImageView tvModelimage;
        private TextView tvModelname;
        private TextView tvIpaddress;
        private TextView tvSerialnumber;
        private TextView tvFwversion;

        public ViewHolder(View view) {
            super(view);
            tvModelimage = (ImageView) view.findViewById(R.id.tv_modelimage);
            tvModelname = (TextView) view.findViewById(R.id.tv_modelname);
            tvIpaddress = (TextView) view.findViewById(R.id.tv_ipaddress);
            tvSerialnumber = (TextView) view.findViewById(R.id.tv_serialnumber);
            tvFwversion = (TextView) view.findViewById(R.id.tv_fwversion);
        }
    }
}
