package com.foream.demo;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.ArrayMap;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.foream.api.CamInfo;
import com.foream.api.ForeamCamCtrl;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class CamScanListActivity extends AppCompatActivity {

    private final static String TAG = "CamScanListActivity";

    private TextView tvBack;
    private TextView tvRefresh;
    private RecyclerView rvOnlinecamlist;
    private ForeamCamCtrl mForeamCamCtrl;
    private CamRecyclerViewAdapter camRecyclerViewAdapter;
    private android.support.v4.util.ArrayMap<String, CamInfo> camList;
    Timer refreshTimer;//定时刷新相机在线列表信息
    Timer backTimer;//定时返回到主界面--30s

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cam_scan_list);

        tvBack = (TextView) findViewById(R.id.tv_back);
        tvBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        tvRefresh = (TextView) findViewById(R.id.tv_refresh);
        tvRefresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                mForeamCamCtrl.startScan();
            }
        });

        camList = new android.support.v4.util.ArrayMap<>();

        rvOnlinecamlist = (RecyclerView) findViewById(R.id.rv_onlinecamlist);
        LinearLayoutManager layoutManager = new LinearLayoutManager(CamScanListActivity.this, LinearLayoutManager.HORIZONTAL, false);
        rvOnlinecamlist.setLayoutManager(layoutManager);

        camRecyclerViewAdapter = new CamRecyclerViewAdapter(CamScanListActivity.this, camList);
        rvOnlinecamlist.setAdapter(camRecyclerViewAdapter);

        mForeamCamCtrl = ForeamCamCtrl.getInstance();

        mForeamCamCtrl.setOnReceiveUDPMsgListener(mOnReceiveUDPMsgListener);
        mForeamCamCtrl.startReceive();

        mForeamCamCtrl.startScan();

        refreshTimer = new Timer(true);

        TimerTask task = new TimerTask() {
            public void run() {
                mForeamCamCtrl.startScan();
            }
        };
        refreshTimer.schedule(task, 5000, 5000);
        initTimer();

    }

    @Override
    protected void onStop() {
        freeTimer();
        if (refreshTimer != null) {
            refreshTimer.cancel();
            refreshTimer = null;
        }
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        mForeamCamCtrl.stopReceive();
        super.onDestroy();
    }

    ForeamCamCtrl.OnReceiveUDPMsgListener mOnReceiveUDPMsgListener = new ForeamCamCtrl.OnReceiveUDPMsgListener() {
        public void camIsOnline(String serialNum, String msgValue, String camIP, String ownerId) {
            Log.d(TAG, "收到心跳包，序列号是" + serialNum);
        }

        public void camIsOffline(String serialNum) {

        }

        public void numberOfCamsOnline(android.support.v4.util.ArrayMap<String, CamInfo> arrayList) {
            Log.d(TAG, "收到在线相机总数");
            if (camList.size() > 0) {
                for (int i = 0; i < camList.size(); i++) {
                    String key = camList.keyAt(i);
                    if (arrayList.indexOfKey(key) < 0) {
                        Toast.makeText(CamScanListActivity.this, "相机" + key + "已离线", Toast.LENGTH_LONG).show();
                    }
                }

            }

            camList.clear();

            if (arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); i++) {
                    String key = arrayList.keyAt(i);
                    CamInfo info = arrayList.valueAt(i);
                    camList.put(key, info);
                }
            }
            camRecyclerViewAdapter.notifyDataSetChanged();
        }

    };


    public void initTimer() {
        backTimer = new Timer(true);

        TimerTask task = new TimerTask() {
            public void run() {
                finish();
            }
        };
        backTimer.schedule(task, 30000);

    }

    public void freeTimer() {
        backTimer.cancel();
        backTimer = null;
    }
}
