package com.foream.demo;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import java.util.List;

public class InfoInputActivity extends AppCompatActivity {

    private TextView tvBack;
    private TextView tvConfirm;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_info_input);

        String ssid = getConnectedSsid(this);
        //判断是否需要清掉双引号
        if (ssid.startsWith("\"") && ssid.endsWith("\"")) {

            ssid = ssid.substring(1, ssid.length() - 1);
        }
        getEtSsid().setText(ssid);

        tvBack = (TextView) findViewById(R.id.tv_back);
        tvBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        tvConfirm = (TextView) findViewById(R.id.tv_confirm);
        tvConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent;
                intent = new Intent(getApplicationContext(), QRCodeScanActivity.class);
                intent.putExtra("ssid", getEtSsid().getText().toString());
                intent.putExtra("pwd", getEtPwd().getText().toString());
                startActivity(intent);
            }
        });
    }

    private EditText getEtSsid(){
        return (EditText) findViewById(R.id.et_ssid);
    }

    private EditText getEtPwd(){
        return (EditText) findViewById(R.id.et_pwd);
    }

//    private String getConnectedSsid()
//    {
//        //获取手机连接的ssid
//        WifiManager wifiManager = (WifiManager) getApplicationContext().getSystemService(WIFI_SERVICE);
//        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
//        Log.d("wifiInfo", wifiInfo.toString());
//        Log.d("SSID",wifiInfo.getSSID());
//        return wifiInfo.getSSID();
//    }

    public static String getConnectedSsid(Context context) {
        if (context == null)
            return null;
        if (Build.VERSION.SDK_INT < 26) {
            WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
            WifiInfo info = wifiManager.getConnectionInfo();
            if (info == null || info.getSSID() == null || info.getSSID().length() == 0 || info.getSSID().equals("<unknown ssid>")) {
                ConnectivityManager manager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                NetworkInfo wifiInfo = manager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
                String wifiName = wifiInfo.getExtraInfo();
                if (wifiName == null) wifiName = "";
                return wifiName;
            }
            return info.getSSID().replace("\"", "");
        } else //only used the new way on android 8.0 or above.
            return getSSIDByNetWorkId(context);
    }

    public static String getSSIDByNetWorkId(Context context) {
        String ssid = "";
        WifiManager mWifiManager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        if (null != mWifiManager) {
            WifiInfo info = mWifiManager.getConnectionInfo();
            int networkId = info.getNetworkId();
            List<WifiConfiguration> netConfList = mWifiManager.getConfiguredNetworks();
            for (WifiConfiguration wificonf : netConfList) {
                if (wificonf.networkId == networkId) {
                    ssid = wificonf.SSID;
                    break;
                }
            }
        }
        if (ssid.contains("\"")) {
            ssid = ssid.replace("\"", "");
        }
        return ssid;
    }
}
