package com.foream.demo;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class MainActivity extends AppCompatActivity {

    private TextView tvQrcodescan;
    private TextView tvScanonlinecam;
    private Timer refreshTimer;//定时刷新相机在线列表信息


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        checkPublishPermission();

        tvQrcodescan = (TextView) findViewById(R.id.tv_qrcodescan);
        tvQrcodescan.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(!isWifiActive())
                {
                    Toast.makeText(MainActivity.this, "请打开Wi-Fi", Toast.LENGTH_LONG).show();
                    return;
                }
                Intent intent;
                intent = new Intent(getApplicationContext(), InfoInputActivity.class);
                startActivity(intent);
            }
        });

        tvScanonlinecam = (TextView) findViewById(R.id.tv_scanonlinecam);
        tvScanonlinecam.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(!isWifiActive())
                {
                    Toast.makeText(MainActivity.this, "请打开Wi-Fi", Toast.LENGTH_LONG).show();
                    return;
                }
                Intent intent;
                intent = new Intent(getApplicationContext(), CamScanListActivity.class);
                startActivity(intent);
            }
        });

        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

    }

    @Override
    protected void onPause() {

        freeTimer();
        super.onPause();
    }

    @Override
    protected void onResume() {
        initTimer();
        super.onResume();
    }



    public boolean isWifiActive()
    {
        WifiManager wifi = (WifiManager) getApplicationContext().getSystemService(WIFI_SERVICE);

        if(wifi.getWifiState() != WifiManager.WIFI_STATE_ENABLED )
        {
            return false;
        }
        return true;
    }

    public void initTimer()
    {
//        refreshTimer = new Timer(true);
//
//        TimerTask task = new TimerTask() {
//            public void run() {
//                Intent intent;
//                intent = new Intent(getApplicationContext(), CamScanListActivity.class);
//                startActivity(intent);
//            }
//        };
//        refreshTimer.schedule(task, 5000);

    }

    public void freeTimer()
    {
//

    }

    private boolean checkPublishPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> permissions = new ArrayList<>();
//            if (PackageManager.PERMISSION_GRANTED != ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
//                permissions.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
//            }
//            if (PackageManager.PERMISSION_GRANTED != ActivityCompat.checkSelfPermission(this, Manifest.permission.CAMERA)) {
//                permissions.add(Manifest.permission.CAMERA);
//            }
//            if (PackageManager.PERMISSION_GRANTED != ActivityCompat.checkSelfPermission(this, Manifest.permission.RECORD_AUDIO)) {
//                permissions.add(Manifest.permission.RECORD_AUDIO);
//            }
            if (PackageManager.PERMISSION_GRANTED != ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION)) {
                permissions.add(Manifest.permission.ACCESS_COARSE_LOCATION);
            }
//            if (PackageManager.PERMISSION_GRANTED != ActivityCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE)) {
//                permissions.add(Manifest.permission.READ_PHONE_STATE);
//            }
            if (permissions.size() != 0) {
                ActivityCompat.requestPermissions(this,
                        permissions.toArray(new String[0]),
                        100);
                return false;
            }
        }

        return true;
    }
}
