package com.foream.demo;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.format.Formatter;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.foream.api.CamInfo;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;

import com.foream.api.ForeamCamCtrl;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class QRCodeScanActivity extends AppCompatActivity {

    private final static String TAG = "QRCodeScanActivity";
    private static final int BLACK = 0xff000000;
    private ImageView ivQrimage;
    private TextView tvCamstatus;
    private TextView tvBack, tvStresmType;
    private String ssid;
    private String pwd;
    private String phoneId;
    private String qrCodeString;
    private ForeamCamCtrl mForeamCamCtrl;
    private boolean bTcpType=true;
    private String typeStr="tcp";

    @SuppressLint("HardwareIds")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qrcode_scan);
        ssid = getIntent().getStringExtra("ssid");
        pwd = getIntent().getStringExtra("pwd");

//        phoneId = Settings.Secure.getString(getContentResolver(),Settings.Secure.ANDROID_ID);
//        //只截取id的前5位
//        phoneId=phoneId.substring(0,5);
//        Log.d(TAG, "kc test: 传递过来的值是 ssid: " + ssid + " pwd: " + pwd);


        ivQrimage = (ImageView) findViewById(R.id.iv_qrimage);
        tvCamstatus = (TextView) findViewById(R.id.tv_camstatus);
        tvBack = (TextView) findViewById(R.id.tv_back);
        tvBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        tvStresmType = (TextView) findViewById(R.id.tv_switch_type);
        tvStresmType.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                bTcpType = !bTcpType;


                if(bTcpType) {
                    typeStr = "tcp";
                    tvStresmType.setText("切换成rtsp");
                }
                else {
                    typeStr = "rtsp";
                    tvStresmType.setText("切换成tcp");
                }

                qrCodeString = mForeamCamCtrl.generateQRCode(ssid, pwd, null,typeStr);
                Bitmap mBitmap = createQRCode(qrCodeString, 600, 600);
                if (mBitmap != null) {
                    ivQrimage.setImageBitmap(mBitmap);
                }
            }
        });

        mForeamCamCtrl = ForeamCamCtrl.getInstance();
        qrCodeString = mForeamCamCtrl.generateQRCode(ssid, pwd, null, typeStr);
        Log.d(TAG, "kc test: 生成的二维码字符串值是 " + qrCodeString);

        mForeamCamCtrl.setOnReceiveUDPMsgListener(mOnReceiveUDPMsgListener);
        mForeamCamCtrl.startReceive();

        Bitmap mBitmap = createQRCode(qrCodeString, 600, 600);
        if (mBitmap != null) {
            ivQrimage.setImageBitmap(mBitmap);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        mForeamCamCtrl.stopReceive();
        super.onDestroy();
    }

    /**
     * 创建二维码
     *
     * @param content   content
     * @param widthPix  widthPix
     * @param heightPix heightPix
     * @return 二维码
     */
    public static Bitmap createQRCode(String content, int widthPix, int heightPix) {
        try {
            if (content == null || "".equals(content)) {
                return null;
            }
            // 配置参数
            Map<EncodeHintType, Object> hints = new HashMap<>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            // 容错级别
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            // 图像数据转换，使用了矩阵转换
            BitMatrix bitMatrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, widthPix,
                    heightPix, hints);
            int[] pixels = new int[widthPix * heightPix];
            // 下面这里按照二维码的算法，逐个生成二维码的图片，
            // 两个for循环是图片横列扫描的结果
            for (int y = 0; y < heightPix; y++) {
                for (int x = 0; x < widthPix; x++) {
                    if (bitMatrix.get(x, y)) {
                        pixels[y * widthPix + x] = 0xff000000;
                    } else {
                        pixels[y * widthPix + x] = 0xffffffff;
                    }
                }
            }
            // 生成二维码图片的格式，使用ARGB_8888
            Bitmap bitmap = Bitmap.createBitmap(widthPix, heightPix, Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, widthPix, 0, 0, widthPix, heightPix);
            //必须使用compress方法将bitmap保存到文件中再进行读取。直接返回的bitmap是没有任何压缩的，内存消耗巨大！
            return bitmap;
        } catch (WriterException e) {
            e.printStackTrace();
        }
        return null;
    }

    //获取手机的ip地址
    protected String getIpAddress() {
        WifiManager wifiManager = (WifiManager) getApplicationContext().getSystemService(WIFI_SERVICE);
        int ipAddress = wifiManager.getConnectionInfo().getIpAddress();

        // Convert little-endian to big-endianif needed
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ipAddress = Integer.reverseBytes(ipAddress);
        }

        byte[] ipByteArray = BigInteger.valueOf(ipAddress).toByteArray();

        String ipAddressString;
        try {
            ipAddressString = InetAddress.getByAddress(ipByteArray).getHostAddress();
        } catch (UnknownHostException ex) {
            Log.e("WIFIIP", "Unable to get host address.");
            ipAddressString = null;
        }

        return ipAddressString;
    }

    ForeamCamCtrl.OnReceiveUDPMsgListener mOnReceiveUDPMsgListener = new ForeamCamCtrl.OnReceiveUDPMsgListener() {
        public void camIsOnline(String serialNum, String msgValue, String camIP, String ownerId) {
            Log.d(TAG, "收到心跳包，序列号是"+serialNum);
            tvCamstatus.setText("相机" + serialNum+"已上线 IP地址" + camIP);
        }

        public void camIsOffline(String serialNum) {

        }

        public void numberOfCamsOnline(android.support.v4.util.ArrayMap<String, CamInfo> arrayList) {


        }

    };
}
